# 画面設計書 50-フォームレイアウト（Bootstrap 5 水平）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するBootstrap 5対応の水平フォームレイアウトテーマ（bootstrap_5_horizontal_layout.html.twig）の画面設計書である。bootstrap_5_layoutを基盤として、Bootstrap 5のグリッドシステムを利用した水平配置のフォームレンダリングを行う。

### 本画面の処理概要

**業務上の目的・背景**：Bootstrap 5の水平フォームレイアウトは、Bootstrap 5のFlexboxベースのグリッドシステム（col-sm-2 / col-sm-10）を使用してラベルとフィールドを横並びに配置する。Bootstrap 5テーマの全機能（form-floating、input-group、form-switch、form-select等）を水平レイアウトで利用可能である。Bootstrap 4の水平レイアウトとの主な違いは、mb-3クラスの使用、form-floatingとinput-groupの水平レイアウト対応が追加された点である。

**画面へのアクセス方法**：Symfonyの設定で`twig.form_themes`に`'bootstrap_5_horizontal_layout.html.twig'`を指定する。

**主要な操作・処理内容**：
1. ラベルにcol-form-labelクラスとcol-sm-2グリッドクラスを適用
2. フィールドをcol-sm-10グリッドクラスのdivでラップ
3. フォーム行にmb-3 rowクラスを適用
4. form-floatingレイアウト時は空ラベル列 + div.form-floating構造で水平配置
5. input-groupレイアウト時は空ラベル列 + div.input-group構造で水平配置
6. expanded（展開型）要素はfieldset_form_rowで処理
7. label=falseの場合、空のdiv.col-sm-2でスペースを確保
8. submit/reset/button/checkbox行はラベル列空+フィールド列で配置

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Bootstrap 5対応の水平フォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるBootstrap 5水平用ブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。

```yaml
twig:
    form_themes: ['bootstrap_5_horizontal_layout.html.twig']
```

## 入出力項目

bootstrap_5_layoutと同一の変数に加え、以下の水平レイアウト固有のブロックを使用する。

| ブロック名 | デフォルト値 | 説明 |
|-----------|-------------|------|
| form_label_class | col-sm-2 | ラベル列のグリッドクラス |
| form_group_class | col-sm-10 | フィールド列のグリッドクラス |

## 表示項目

### オーバーライドされた主要ブロック一覧

| ブロック名 | 説明 | 出力HTML構造 |
|-----------|------|-------------|
| form_label | ラベルにcol-form-label+col-sm-2適用、form-floating/input-group時は除外、label=falseで空div | `<label class="col-form-label col-sm-2">` or `<div class="col-sm-2"></div>` |
| form_label_class | ラベル列グリッドクラス | `col-sm-2` |
| form_row_render | expanded/form-floating/input-group/通常の4パターン水平レイアウト | 下記詳細参照 |
| fieldset_form_row | expanded要素用の水平fieldset構造 | `<fieldset><div class="row">label + div.col-sm-10</div></fieldset>` |
| submit_row | 送信ボタンの水平配置 | `<div class="mb-3 row"><div class="col-sm-2"></div><div class="col-sm-10">button</div></div>` |
| reset_row | リセットボタンの水平配置 | submit_rowと同構造 |
| button_row | 汎用ボタンの水平配置 | submit_rowと同構造 |
| checkbox_row | チェックボックスの水平配置 | `<div class="mb-3 row"><div class="col-sm-2"></div><div class="col-sm-10">widget+help+errors</div></div>` |
| form_group_class | フィールド列グリッドクラス | `col-sm-10` |

### form_row_renderの4パターン

| パターン | 条件 | HTML構造 |
|---------|------|---------|
| expanded | expanded=true | `fieldset_form_row`に委譲 |
| form-floating | row_classにform-floatingを含む | `<div class="mb-3 row"><div class="col-sm-2"></div><div class="col-sm-10"><div class="form-floating">widget+label</div>+help+errors</div></div>` |
| input-group | row_classにinput-groupを含む | `<div class="mb-3 row"><div class="col-sm-2"></div><div class="col-sm-10"><div class="input-group">label+widget+help</div>+errors</div></div>` |
| 通常 | 上記以外 | `<div class="mb-3 row">label + <div class="col-sm-10">widget+help+errors</div></div>` |

## イベント仕様

### 1-Bootstrap 5水平レイアウトでのフォームレンダリング

主なHTML出力例：
```html
<!-- 通常フィールド -->
<div class="mb-3 row">
    <label class="form-label col-form-label col-sm-2" for="form_name">Name</label>
    <div class="col-sm-10">
        <input type="text" class="form-control" id="form_name" />
        <div class="form-text mb-0">Enter your name</div>
    </div>
</div>

<!-- form-floating水平レイアウト -->
<div class="mb-3 row">
    <div class="col-sm-2"></div>
    <div class="col-sm-10">
        <div class="form-floating">
            <input type="text" class="form-control" id="form_email" />
            <label for="form_email">Email</label>
        </div>
        <div class="form-text mb-0">...</div>
    </div>
</div>

<!-- input-group水平レイアウト -->
<div class="mb-3 row">
    <div class="col-sm-2"></div>
    <div class="col-sm-10">
        <div class="input-group">
            <label class="input-group-text" for="form_price">Price</label>
            <input type="text" class="form-control" id="form_price" />
            <div class="input-group-text">Help</div>
        </div>
        <div class="invalid-feedback d-block">Error message</div>
    </div>
</div>

<!-- expanded選択要素 -->
<fieldset class="mb-3">
    <div class="row">
        <legend class="col-form-label col-sm-2">Color</legend>
        <div class="col-sm-10">
            <div class="form-check">...</div>
        </div>
    </div>
</fieldset>

<!-- 送信ボタン -->
<div class="mb-3 row">
    <div class="col-sm-2"></div>
    <div class="col-sm-10">
        <button type="submit" class="btn-primary btn">Submit</button>
    </div>
</div>
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ |

## メッセージ仕様

bootstrap_5_layoutと同一。

## 例外処理

テーマテンプレート自体は例外をスローしない。

## 備考

- `{% use 'bootstrap_5_layout.html.twig' %}`により、bootstrap_5_layoutの全ブロックを基盤として利用
- 4層の継承構造：form_div_layout → bootstrap_base_layout → bootstrap_5_layout → bootstrap_5_horizontal_layout
- Bootstrap 4水平レイアウトとの主な違い：
  - form-group → mb-3
  - form-floating対応の水平レイアウトが追加
  - input-group対応の水平レイアウトが追加
  - button_rowが新設（submit_row/reset_rowに加えて汎用ボタン対応）
- form-floatingおよびinput-group時は、ラベル列が空div（col-sm-2）となり、form-floating/input-group構造がフィールド列（col-sm-10）内にネストされる
- row_classからform-floating/input-groupクラスが除去され、行ラッパーには適用されない

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造を理解する |

#### Step 2: 基盤テーマのチェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 最も基盤となるテーマ |
| 2-2 | bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | Bootstrap共通基盤テーマ |
| 2-3 | bootstrap_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_layout.html.twig` | Bootstrap 5標準テーマ |

#### Step 3: 水平レイアウト固有のオーバーライドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bootstrap_5_horizontal_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_horizontal_layout.html.twig` | 水平レイアウト固有のブロック定義を理解する |

**主要処理フロー**:
1. **L1**: `{% use 'bootstrap_5_layout.html.twig' %}` - 基盤テンプレートの読み込み
2. **L5-18**: `form_label` - form-floating/input-group時の除外処理、col-form-label+col-sm-2適用、label=falseで空div
3. **L20-22**: `form_label_class` - col-sm-2
4. **L26-67**: `form_row_render` - 4パターンの水平レイアウト分岐
  - L27-28: expanded → fieldset_form_row
  - L30-34: row_classからform-floating/input-groupを検出・除去
  - L36-51: form-floating/input-groupパターン（空ラベル列 + ネスト構造）
  - L57-63: 通常パターン（label + div.col-sm-10）
5. **L69-84**: `fieldset_form_row` - expanded要素用fieldset/legend構造
6. **L86-93**: `submit_row` - mb-3 row + 空ラベル列 + フィールド列
7. **L95-102**: `reset_row` - submit_rowと同構造
8. **L104-111**: `button_row` - submit_rowと同構造
9. **L113-122**: `checkbox_row` - 空ラベル列 + widget+help+errors
10. **L124-126**: `form_group_class` - col-sm-10

### プログラム呼び出し階層図

```
{{ form_row(form.field) }}
    |
    +-- form_row [form_div_layoutから継承]
    |       +-- aria属性の計算
    |       +-- form_row_render [bootstrap_5_horizontal_layout オーバーライド]
    |               |
    |               +-- [expanded] fieldset_form_row
    |               |       +-- <fieldset class="mb-3"><div class="row">
    |               |       +-- form_label → <legend class="col-form-label col-sm-2">
    |               |       +-- <div class="col-sm-10">widget+help+errors</div>
    |               |
    |               +-- [form-floating] <div class="mb-3 row">
    |               |       +-- <div class="col-sm-2"></div>
    |               |       +-- <div class="col-sm-10">
    |               |       |       +-- <div class="form-floating">widget + label</div>
    |               |       |       +-- help + errors
    |               |       +-- </div></div>
    |               |
    |               +-- [input-group] <div class="mb-3 row">
    |               |       +-- <div class="col-sm-2"></div>
    |               |       +-- <div class="col-sm-10">
    |               |       |       +-- <div class="input-group">label + widget + help</div>
    |               |       |       +-- errors
    |               |       +-- </div></div>
    |               |
    |               +-- [通常] <div class="mb-3 row">
    |                       +-- form_label → <label class="col-form-label col-sm-2">
    |                       +-- <div class="col-sm-10">widget + help + errors</div>
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
(+ row_attr:                                        |
  form-floating,    テーマ検索順序:                    v
  input-group等)    1. bootstrap_5_horizontal    Bootstrap 5 水平レイアウトHTML
                    2. bootstrap_5_layout        (<div class="mb-3 row">,
                    3. bootstrap_base_layout      <label class="col-sm-2">,
                    4. form_div_layout            <div class="col-sm-10">,
                                                  <div class="form-floating">, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bootstrap_5_horizontal_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_horizontal_layout.html.twig` | テンプレート | Bootstrap 5水平フォームテーマ（全127行） |
| bootstrap_5_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_layout.html.twig` | テンプレート | Bootstrap 5標準フォームテーマ（全371行） |
| bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | テンプレート | Bootstrap共通基盤テーマ（全209行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 最も基盤となるフォームレイアウトテーマ（全482行） |
